class ManualController {
  boolean button_X;
  boolean button_Y;
  boolean button_A;
  boolean button_B;
  boolean button_LB;
  boolean button_RB;
  boolean button_LT;
  boolean button_RT;
  int     hat;
  int     autoCommand;  // 0: 無効, 1-10 : autoCommand1() - autoCommand10()
  
  // 立ち上がり微分動作検出用（あまり良い対策ではない）
  boolean button_LB0, button_RB0, button_X0;  // 一つ前のcheck時の状態
  boolean button_LT0, button_RT0;
  
  ManualController() {
    button_LB0 = button_RB0 = button_X0 = false;
  }
  // 選択された簡易自動コマンドを実行する
  void run_autoCommand() {
    switch (autoCommand) {
      case  1 : autoCommand1();  break;
      case  2 : autoCommand2();  break;
      case  3 : autoCommand3();  break;
      case  4 : autoCommand4();  break;
      case  5 : autoCommand5();  break;
      case  6 : autoCommand6();  break;
      case  7 : autoCommand7();  break;
      case  8 : autoCommand8();  break;
      case  9 : autoCommand9();  break;
      case 10 : autoCommand10(); break;
    }
  }
  // ゲームパッドやキーボードの状態をチェック
  void check() {
    if (debug_nogamepad) {
      button_X  = false;
      button_Y  = false;
      button_A  = false;
      button_B  = false;
      button_LB = false;
      button_RB = false;
      button_LT = false;
      button_RT = false; 
      hat       = 0;
    } else {
      // 立ち下がり微分動作検出用（立ち上がり検出とはメカニズムが異なる：検出はrobotController内で行う）
      button_LT0 = button_LT; button_RT0 = button_RT;
      // ボタンの状態を取得
      button_X  = button_0_X.pressed()  ? true : false;
      button_Y  = button_1_Y.pressed()  ? true : false;
      button_A  = button_2_A.pressed()  ? true : false;
      button_B  = button_3_B.pressed()  ? true : false;
      button_LB = button_4_LB.pressed() ? true : false;
      button_RB = button_5_RB.pressed() ? true : false;
      button_LT = button_6_LT.pressed() ? true : false;
      button_RT = button_7_RT.pressed() ? true : false; 
      hat       = (int)hat_13.getValue();
      // 立ち上がり微分動作用補正
      if (button_LB0 && button_LB) button_LB  = false;
        else                       button_LB0 = button_LB;
      if (button_RB0 && button_RB) button_RB  = false;
        else                       button_RB0 = button_RB;
      if (button_X0  && button_X)  button_X   = false;
        else                       button_X0  = button_X;
    }
    // キーボード操作による上書き
    button_X  |= ksup.plus;      // トグル動作なので立ち上がりのみ  
    button_Y  |= ksup.tenkey[0]; // トグル動作なので立ち上がりのみ
    button_A  |= ks.minus;
    button_B  |= ks.spc;
    button_LB |= ksup.tenkey[7]; // 逐次動作なので立ち上がりのみ
    button_RB |= ksup.tenkey[9]; // 逐次動作なので立ち上がりのみ
    button_LT |= ks.tenkey[1];
    button_RT |= ks.tenkey[3];
    if (hat == 0) {  // ゲームパッド優先
      if (ks.tenkey[8])      hat = 2;
      else if (ks.tenkey[6]) hat = 4;
      else if (ks.tenkey[2]) hat = 6;
      else if (ks.tenkey[4]) hat = 8;
    }
  }
  // 簡易自動コマンドの番号指定
  void setAutoCommand(int no) {
    if ((no < 1) || (no > 10)) return;
    autoCommand = no;
  }
  void resetAutoCommand() {
    autoCommand = 0;
  }
}

ManualController mc = new ManualController();

/*
Boolean val = hat. up();
Boolean val = hat. down();
Boolean val = hat. left();
Boolean val = hat. right();
Boolean val = hat. pressed();

hatのgetValue()は，
0: 押されていない
1: 左上
2: 上
3: 右上
4: 右
5: 右下
6: 下
7: 左下
8: 左
と，左上を基準にCWに割り振られている
*/

// キーボード入力（押し下げ）：押しっぱなしでも検知されてしまう
void keyPressed() {
  if ((keyCode >= 96) && (keyCode <= 105)) { // 0-9: 10key //<>//
    if (!ks.tenkey[keyCode - 96]) ks.tenkey[keyCode - 96] = ksup.tenkey[keyCode - 96] = true;
  } else if ((keyCode >= 112) && (keyCode <= 121)) {  // f1-f10
    if (mc.autoCommand == keyCode - 112 + 1) mc.resetAutoCommand();
    else                                     mc.setAutoCommand(keyCode - 112 + 1);
  } else {
    switch (keyCode) {
      case  32 : if (!ks.spc)   ks.spc   = ksup.spc   = true; break;
      case  37 : if (!ks.left)  ks.left  = ksup.left  = true; break;
      case  38 : if (!ks.up)    ks.up    = ksup.up    = true; break;
      case  39 : if (!ks.right) ks.right = ksup.right = true; break;
      case  40 : if (!ks.down)  ks.down  = ksup.down  = true; break;
      case  16 : if (!ks.shift) ks.shift = ksup.shift = true; break;
      case  17 : if (!ks.ctrl)  ks.ctrl  = ksup.ctrl  = true; break;
      case  18 : if (!ks.alt)   ks.alt   = ksup.alt   = true; break;
      case  36 : if (!ks.home)  ks.home  = ksup.home  = true; break;
      case 107 : if (!ks.plus)  ks.plus  = ksup.plus  = true; break;
      case 109 : if (!ks.minus) ks.minus = ksup.minus = true; break;
      default :
    }
  }
}

// キーボード入力（リリース）
void keyReleased() {
  if ((keyCode >= 96) && (keyCode <= 105)) { // 0-9: 10key
    if (ks.tenkey[keyCode - 96]) { ks.tenkey[keyCode - 96] = false; ksdown.tenkey[keyCode - 96] = true; }
  } else {
    switch (keyCode) {
      case  32 : if (ks.spc)   { ks.spc   = false; ksdown.spc   = true; } break;
      case  37 : if (ks.left)  { ks.left  = false; ksdown.left  = true; } break;
      case  38 : if (ks.up)    { ks.up    = false; ksdown.up    = true; } break;
      case  39 : if (ks.right) { ks.right = false; ksdown.right = true; } break;
      case  40 : if (ks.down)  { ks.down  = false; ksdown.down  = true; } break;
      case  16 : if (ks.shift) { ks.shift = false; ksdown.shift = true; } break;
      case  17 : if (ks.ctrl)  { ks.ctrl  = false; ksdown.ctrl  = true; } break;
      case  18 : if (ks.alt)   { ks.alt   = false; ksdown.alt   = true; } break;
      case  36 : if (ks.home)  { ks.home  = false; ksdown.home  = true; } break;
      case 107 : if (ks.plus)  { ks.plus  = false; ksdown.plus  = true; } break;
      case 109 : if (ks.minus) { ks.minus = false; ksdown.minus = true; } break;
      default :
    }
  }
}

class KeyboardStatus {
  boolean [] tenkey = {false, false, false, false, false, false, false, false, false, false};
  boolean spc,left, up, right, down, shift, ctrl, alt, home, plus, minus;
  KeyboardStatus() {
    reset();
  }
  void reset() {
    for (int i = 0; i <= 9; i++) tenkey[i] = false;
    spc = left = up = right = down = shift = ctrl = alt = home = plus = minus = false;
  }
}

KeyboardStatus ks     = new KeyboardStatus();  // 現在のキーボードの状態
KeyboardStatus ksup   = new KeyboardStatus();  // キーボードの状態の立ち上がり微分出力（1scanのみ有効）
KeyboardStatus ksdown = new KeyboardStatus();  // キーボードの状態の立ち下がり微分出力（1scanのみ有効）

/* key keyCode (0-9: 10key, 0-9: 48-57)
0  96
1  97
2  98
3  99
4  100
5  101
6  102
7  103
8  104
9  105
SPC  32
left  37
up  38
right  39
down  40
shift  16
ctrl  17
alt  18
home  36

f1  112
f2  113
f3  114
f4  115
f5  116
f6  117
f7  118
f8  119
f9  120
f10  121
f11  none
f12  none

Enter  10
*  106
+  107
.  110
-  109
/  111
*/
